'' ASTEROID BELT (EXTREM-256)
' MSX-BASIC
' Giovanni Nunes <giovanni.nunes@gmail.com>
' for Homeputerium's BASIC 10Liners 2018 competition
'
' Version to be translated by Inliner:
' https://github.com/plainspooky/inliner/
'
' use:
' inliner asteroid_belt_inliner.bas --start=100 --upper
'

' define ESC chr$(27)

' define SHIP 15
' define SHOTS 10

' define TOP 6176
' define BOTTOM 6880
' define MIDDLE 6528
' define CHECK 6848

' define PAL 10
' define NTSC 12

initialize:
	defint a-z
	color 15,0,0
	key off
	screen 1,0,0
	width 32
	'
	i=rnd(-time)
	i$={{ESC}}+"L"
	x=15

graphics:
	vpoke 8192,96
	vpoke 8193,128
	vpoke 8194,144
	vpoke 8195,112
	'
	sprite$(0)=string$(2,24)
		\+string$(2,60)
		\+string$(2,126)
		\+string$(2,255)
	'
	for j=0 to 255 step 64
		for i=j to j+7
			read k
			vpoke i,k
		next i,j

opening:
	locate 9,3
		print "ASTEROID BELT!"
	locate 1,6
		print "Try to navigate your spaceship     through an asteroid belt."
	locate 3,10
		print "Use arrow-keys to move the       ship and <Space> to shot"
	locate 4,21
		print "Press <Enter> to Start!!"
	goto {{wait_for_enter}}

main_loop:
	time=0	
	print chr$(11)"F"f,"S"s;chr$(31)i$;
	'
	' put new asteroids
	'
	for i=0 to 2
		j=rnd(1)*32
		vpoke {{TOP}}+j,i*8
	next
	'
	' update spaceship
	'
	put sprite 0,(x*8,183),{{SHIP}}
	'
	' check collision
	'
	if vpeek({{CHECK}}+x)<>32 
	\ then {{game_over}}
	\ else 
		'
		' increase score
		'
		s=s+4
		'
		' spaceship moving
		'
		k$=inkey$
		x=x-(k$=chr$(28) and x<31)+(k$=chr$(29) and x>0)
		'
		' and shot laser
		'
		if k$=" " and f>0 then {{shot_laser}}

sync_wait:
' do loop if time>NTSC (change to PAL in 50Hz systems)
	if time<{{NTSC}}
	\ then {{@}}
	\ else {{main_loop}}

shot_laser:
	'
	' draw laser
	'
	for i={{BOTTOM}} to {{MIDDLE}} step -32
		vpoke i+x,24
	next i
	'
	' erase laser
	'
	for i={{BOTTOM}} to {{MIDDLE}} step -32
		vpoke i+x,32
	next i
	'
	' decrease shots
	'
	f=f-1
	goto {{sync_wait}}

game_over:
	'
	' remove spaceship
	'
	put sprite 0,(-16,-17)
	'
	' remove asteroids
	'
	locate 0,1
	for i=0 to 23
		print i$;
	next i
	'
	' game over message and press
	'
	locate 7,3
	print "*** GAME OVER! ***"
	locate 4,21
	print "Press <Enter> to Restart"

wait_for_enter:
	if inkey$<>chr$(13)
	\ then {{@}}
	\ else f={{SHOTS}}
		s=0
		cls
		goto {{main_loop}}

graphic_patterns:
	data &h00,&h18,&h3c,&h7c,&h3e,&h3e,&h1c,&h00,
		\&h00,&h1e,&h7e,&h3e,&h3c,&h7c,&h1c,&h00,
		\&h00,&h0c,&h3e,&h3c,&h78,&h3e,&h0c,&h00,
		\&h18,&h18,&h18,&h18,&h18,&h18,&h18,&h18
